import { Client, Variables, logger } from "camunda-external-task-client-js";

const config = { baseUrl: "http://localhost:8080/engine-rest", use: logger };

const client = new Client(config);

client.subscribe("grant-roles", async function({ task, taskService }) {
  const dev_name = task.variables.get("dev_name");
  const dev_roles = task.variables.get("dev_roles");

  console.log(logger.success("Granting Roles to " + dev_name));

  for (let i = 0; i < dev_roles.length; i++) {
    console.log(logger.success("  Granted Role: " + dev_roles[i]));
  }

  console.log(logger.success("Granted Roles to " + dev_name));

  await taskService.complete(task);
});
