import { Client, Variables, logger } from "camunda-external-task-client-js";

const config = { baseUrl: "http://localhost:8080/engine-rest", use: logger };

const client = new Client(config);

client.subscribe("determine-roles", async function({ task, taskService }) {
  const dev_prod_support = task.variables.get("dev_prod_support");
  const dev_name = task.variables.get("dev_name");

  const roles = [];
  roles.push("IssueTracker: user");
  roles.push("VersionControl: developer");
  roles.push("VersionControl: admin");
  roles.push("DeploymentPipeline: deploy");

  if (dev_prod_support) {
    roles.push("ProdAccess: third-line-support");
  }

  const processVariables = new Variables();
  processVariables.set("dev_roles", roles);

  console.log(logger.success("Determined " + roles.length + " Roles for " + dev_name));
  await taskService.complete(task, processVariables);
});
